<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Models\User;

class crudController extends Controller
{
    public function addUser(Request $request){
        $request->validate([
'firstname' => 'required',
'lastname' => 'required',
'email' => 'required',
'phone' => 'required|numeric',
'address' => 'required',
'post' => 'required'

        ]);
        $user=DB::table('users')
        ->insert([
            'firstName' => $request->firstname,
            'lastName' => $request->lastname,
            'emailId' => $request->email,
            'phoneNumber' => $request->phone,
            'streetAddress' => $request->address,
            'zipCode' => $request->post,

        ]);
  
        if($user){
            return redirect()->route('read')->with('success', 'Data inserted successfully.');
        } else{
            return redirect()->route('read')->with('error', 'Something went wrong . Please Try again.');
        }
    }


public function showUser(){
    $users=DB::table('users')
                 ->paginate(5)
                 ->appends(['sort' => 'votes']);
    return view('read',['data' => $users]);
}
//update
public function updatePage(string $id){
    //$users=DB::table('users')->where('id' , $id)->get();
    $users=DB::table('users')->find($id);
    return view('update',['data' => $users]);
}

public function updateUser(Request $request, $id){
   // return $request;
    $user=DB::table('users')
    ->where('id', $id)
    ->update([
        'firstName' => $request->firstname,
        'lastName' => $request->lastname,
        'emailId' => $request->email,
        'phoneNumber' => $request->phone,
        'streetAddress' => $request->address,
        'zipCode' => $request->post

    ]);

    if($user){
        return redirect()->route('read')->with('success', 'Data updated successfully.');
       // echo "<h2>Data Inserted Successfuly</h2>";

    } else{
        return redirect()->route('read')->with('error', 'Something went wrong . Please Try again.');

    }
}

public function deleteUser(string $id){
    $user=DB::table('users')
    ->where('id', $id)
    ->delete();
    if($user){
        return redirect()->route('read')->with('success', 'Data deleted.');
       // echo "<h2>Data Inserted Successfuly</h2>";

    } else{

        echo "<h2>Something went wrong . Please Try again. </h2>";

    }
}



}
