<?php
// Function to calculate EMI
function calculateEMI($principal, $rate, $time) {
    $rate = $rate / (12 * 100); // monthly interest rate
    $time = $time * 12; // number of months

    $emi = ($principal * $rate * pow(1 + $rate, $time)) / (pow(1 + $rate, $time) - 1);
    return $emi;
}

$emi = $total_payment = $total_interest = "";
$principal = $rate = $time = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $principal = $_POST['principal'];
    $rate = $_POST['rate'];
    $time = $_POST['time'];

    $emi = calculateEMI($principal, $rate, $time);
    $time_months = $time * 12;
    $total_payment = $emi * $time_months;
    $total_interest = $total_payment - $principal;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Advanced EMI Calculator</title>
    <style>
        body { font-family: Arial, sans-serif; background: #eef2f7; padding: 40px; }
        .container { max-width: 800px; margin: auto; background: #fff; padding: 25px; 
                     border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #2c3e50; margin-bottom: 20px; }
        label { display: block; margin-top: 12px; font-weight: bold; }
        input { width: 100%; padding: 10px; margin-top: 5px; border: 1px solid #ccc; 
                border-radius: 6px; font-size: 16px; }
        button { background: #28a745; color: #fff; border: none; padding: 12px; width: 100%; 
                 margin-top: 20px; border-radius: 6px; cursor: pointer; font-size: 16px; }
        button:hover { background: #218838; }
        .result { margin-top: 25px; padding: 15px; border-radius: 8px; background: #f9f9f9; }
        .result h3 { margin: 0 0 10px; color: #333; }
        .summary, .amortization { margin-top: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 14px; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 8px; text-align: center; }
        th { background: #f1f1f1; }
    </style>
</head>
<body>
    <div class="container">
        <h2>💰 Advanced EMI Calculator</h2>
        <form method="post">
            <label>Loan Amount (₹)</label>
            <input type="number" name="principal" required value="<?= $principal ?>">

            <label>Annual Interest Rate (%)</label>
            <input type="number" step="0.01" name="rate" required value="<?= $rate ?>">

            <label>Loan Tenure (Years)</label>
            <input type="number" name="time" required value="<?= $time ?>">

            <button type="submit">Calculate EMI</button>
        </form>

        <?php if ($emi) { ?>
            <div class="result">
                <h3>📊 Loan Summary</h3>
                <p><strong>Monthly EMI:</strong> ₹<?= number_format($emi, 2) ?></p>
                <p><strong>Total Payment:</strong> ₹<?= number_format($total_payment, 2) ?></p>
                <p><strong>Total Interest Payable:</strong> ₹<?= number_format($total_interest, 2) ?></p>
            </div>

            <div class="amortization">
                <h3>📅 Amortization Schedule (Month-wise)</h3>
                <table>
                    <tr>
                        <th>Month</th>
                        <th>Opening Balance (₹)</th>
                        <th>EMI (₹)</th>
                        <th>Interest (₹)</th>
                        <th>Principal (₹)</th>
                        <th>Closing Balance (₹)</th>
                    </tr>
                    <?php 
                    $balance = $principal;
                    $monthly_rate = $rate / (12 * 100);
                    for ($m = 1; $m <= $time * 12; $m++) {
                        $interest = $balance * $monthly_rate;
                        $principal_component = $emi - $interest;
                        $closing_balance = $balance - $principal_component;

                        echo "<tr>
                                <td>$m</td>
                                <td>".number_format($balance, 2)."</td>
                                <td>".number_format($emi, 2)."</td>
                                <td>".number_format($interest, 2)."</td>
                                <td>".number_format($principal_component, 2)."</td>
                                <td>".number_format(max($closing_balance, 0), 2)."</td>
                              </tr>";

                        $balance = $closing_balance;
                        if ($balance <= 0) break;
                    }
                    ?>
                </table>
            </div>
        <?php } ?>
    </div>
</body>
</html>
