@extends('app')

@section('title', 'Login')

@section('content')
<h2>Welcome Back</h2>

@if(session('success'))
<div class="alert alert-success">{{ session('success') }}</div>
@endif

@if($errors->any())
<div class="alert alert-danger">{{ $errors->first() }}</div>
@endif

<form action="/login" method="POST">
    @csrf
    <div class="mb-3">
        <label class="form-label">Email Address</label>
        <input type="email" class="form-control" name="email" placeholder="Enter your email" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" class="form-control" name="password" placeholder="Enter password" required>
    </div>

    <button type="submit" class="btn btn-primary w-100">Login</button>

    <p class="text-center mt-3 mb-0">
        Don’t have an account? <a href="/register">Register</a>
    </p>
</form>
@endsection
