<?php 
// Include the MongoDB connection
 require 'db.php';  
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect sanitized form data
    $name   = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING);
    $email  = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $mobile = filter_input(INPUT_POST, 'mobile', FILTER_SANITIZE_STRING);
    $city   = filter_input(INPUT_POST, 'city', FILTER_SANITIZE_STRING);
    $state  = filter_input(INPUT_POST, 'state', FILTER_SANITIZE_STRING);

    try {
        // Prepare the document
        $bulk = new MongoDB\Driver\BulkWrite;
        $doc = [
            '_id'        => new MongoDB\BSON\ObjectID(),
            'name'       => $name,
            'email'      => $email,
            'mobile'     => $mobile,
            'city'       => $city,
            'state'      => $state,
            'created_at' => new MongoDB\BSON\UTCDateTime()
        ];
        $bulk->insert($doc);

        // Execute insertion into "mydatabase.users"
        $manager->executeBulkWrite('mydatabase.users', $bulk);
    $message = "<p style='color:green;'>Data submitted successfully!</p>";
    } catch (MongoDB\Driver\Exception\Exception $e) {
        echo "Error inserting data: " . $e->getMessage();
    }

}

 ?>

 <!DOCTYPE html>
<!-- Coding by CodingLab | www.codinglabweb.com-->
<html lang="en" dir="ltr">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> Registration or Sign Up form in HTML CSS | CodingLab </title>
    <link rel="stylesheet" href="style.css">
   </head>
<body>
  <div class="wrapper">
    <h2>Registration</h2>
    <?php echo $message; ?>
    <form action="" method="post">
  <div class="input-box">
    <input type="text" name="name" placeholder="Enter your name" required>
  </div>
  <div class="input-box">
    <input type="text" name="email" placeholder="Enter your email" required>
  </div>
  <div class="input-box">
    <input type="text" name="mobile" placeholder="Enter mobile number" required>
  </div>
  <div class="input-box">
    <input type="text" name="city" placeholder="Enter city name" required>
  </div>
  <div class="input-box">
    <input type="text" name="state" placeholder="Enter state name" required>
  </div>
  <div class="input-box button">
    <input type="submit" value="Submit Now">
  </div>
</form>

  </div>

</body>
</html>
